class DM_HUD extends ChallengeHUD config(User);

#exec OBJ LOAD FILE=..\Textures\LadrStatic.utx PACKAGE=Botpack.LadrStatic

#exec Texture Import File=Textures\Icon_Skull.bmp Name=Icon_Skull Group=HUD MIPS=ON
#exec Texture Import File=Textures\Tile_Background.bmp Name=Tile_Background Group=HUD MIPS=ON
#exec Texture Import File=Textures\Icon_Armor.bmp Name=Icon_Armor Group=HUD MIPS=ON
#exec Texture Import File=Textures\Icon_Boots.bmp Name=Icon_Boots Group=HUD MIPS=ON
#exec Texture Import File=Textures\Icon_ArmorSB.bmp Name=Icon_ArmorSB Group=HUD MIPS=ON
#exec Texture Import File=Textures\tombstone.bmp Name=tombstone Group=HUD MIPS=ON
#exec Texture Import File=Textures\Icon_Time.bmp Name=Icon_Time Group=HUD MIPS=ON
#exec Texture Import File=Textures\Icon_Health.bmp Name=Icon_Health Group=HUD MIPS=ON
#exec Texture Import File=Textures\Icon_Monitor.bmp Name=Icon_Monitor Group=HUD MIPS=ON
#exec Texture Import File=Textures\HSskull.bmp Name=HSskull Group=HUD MIPS=ON
#exec Texture Import File=Textures\Scroll.bmp Name=Scroll Group=HUD MIPS=ON
#exec Texture Import File=Textures\flueben.bmp Name=flueben Group=HUD MIPS=ON
#exec Texture Import File=Textures\Warning.bmp Name=Warning Group=HUD MIPS=ON

var bool bSetStart;
var float Speed, a, b;
var int HealthColor;
var color WarningColor;
var int WarningCountDown,MapsCountDown;

var PlayerReplicationInfo Ordered[32];
var bool bTimeDown,bRenderMaps;

var() int SizeY,Count;
var string CurrentMessage;
var float MOTDFadeOutTime;

var float IdentifyFadeTime;
var PlayerReplicationInfo IdentifyTarget;
var Pawn PawnOwner;	// pawn currently managing this HUD (may be the viewtarget of the owner rather than the owner)
var FontInfo MyFonts;

// Localized Messages
var HUDLocalizedMessage ShortMessageQueue[4];
var HUDLocalizedMessage LocalMessages[10];

var texture FaceTexture;
var float FaceTime;
var color FaceTeam;
 
var() localized string VersionMessage, PlayerCountString;
var localized string MapTitleString, AuthorString;
var localized string MapTitleString2, AuthorString2;

var localized string RankString;
var localized string SpreadString;

var int PlayerCount;
var bool bTiedScore;

var string ReceivedMessage;
var string ReceivedName;
var ZoneInfo ReceivedZone;
var float ReceivedTime;
var texture TutIconTex;
var int TutIconX, TutIconY;
var float TutIconBlink;

var globalconfig int CrosshairCount;
var globalconfig string CrossHairs[20];
var texture CrossHairTextures[20];

var texture GrayWeapons[11];
var texture FP1[3], FP2[3], FP3[3];
var int LastReportedTime;
var bool bStartUpMessage, bForceScores;
var bool bTimeValid;
var bool bLowRes;
var bool bResChanged;
var int OldClipX;

// configuration options
var bool bAlwaysHideFrags, bHideCenterMessages;
var globalconfig bool bHideAllWeapons, bHideStatus, bHideAmmo, bHideTeamInfo, bHideFrags, bHideHUD, bHideNoviceMessages, bHideFaces;
var globalconfig bool bUseTeamColor;
var globalconfig byte Opacity;	// should be between 1 and 16
var float Scale;
var byte Style;
var color BaseColor, WhiteColor, RedColor, GreenColor, CyanColor, UnitColor, BlueColor,
		 GoldColor, HUDColor, SolidHUDColor, PurpleColor, TurqColor, GrayColor, FaceColor;

// Identify Strings
var localized string IdentifyName, IdentifyHealth, IdentifyCallsign;
var localized string LiveFeed;

// scoring 
var float ScoreTime;
var int rank, lead;

// showing damage
var vector HitPos[4];
var float HitTime[4];
var float HitDamage[4];

var float PickupTime;

var float WeaponNameFade;
var float MessageFadeTime;
var int MessageFadeCount;
var bool bDrawMessageArea;
var bool bDrawFaceArea;
var float FaceAreaOffset, MinFaceAreaOffset;
var class<CriticalEventPlus> TimeMessageClass;

// Server info.
var ServerInfo ServerInfo;
var bool bShowInfo;

var class<ServerInfo> ServerInfoClass;

var globalconfig string FontInfoClass;

function Destroyed()
{
	Super.Destroyed();
	if ( MyFonts != None )
		MyFonts.Destroy();
}

simulated function PostBeginPlay()
{
	local int i;

	if ( Level.NetMode != NM_Standalone )
		MOTDFadeOutTime = 350;
	FaceAreaOffset = -64;
	MyFonts = FontInfo(spawn(Class<Actor>(DynamicLoadObject(FontInfoClass, class'Class'))));
	Super.PostBeginPlay();
	SetTimer(1.0, True);

	if ( (PlayerPawn(Owner).GameReplicationInfo != None)
		&& (PlayerPawn(Owner).GameReplicationInfo.RemainingTime > 0) )
		TimeMessageClass = class<CriticalEventPlus>(DynamicLoadObject("Botpack.TimeMessage", class'Class'));

	ServerInfo = Spawn(ServerInfoClass, Owner);
	SaveConfig();
}

exec function ShowServerInfo()
{
	if (bShowInfo)
	{
		bShowInfo = False;
	} else {
		bShowInfo = True;
		PlayerPawn(Owner).bShowScores = False;
	}
}
	
simulated function ChangeCrosshair(int d)
{
	Crosshair = Crosshair + d;
	if ( Crosshair >= CrossHairCount )
		Crosshair = 0;
	else
	if ( Crosshair < 0 )
		Crosshair = CrossHairCount-1;
}

simulated function Texture LoadCrosshair(int c)
{
	CrossHairTextures[c] = Texture(DynamicLoadObject(CrossHairs[c], class'Texture'));
	return CrossHairTextures[c];
}

simulated function HUDSetup(canvas canvas)
{
	local int FontSize;

	bResChanged = (Canvas.ClipX != OldClipX);
	OldClipX = Canvas.ClipX;
		
	PlayerOwner = PlayerPawn(Owner);
	if ( PlayerOwner.ViewTarget == None )
		PawnOwner = PlayerOwner;
	else if ( PlayerOwner.ViewTarget.bIsPawn )
		PawnOwner = Pawn(PlayerOwner.ViewTarget);
	else 
		PawnOwner = PlayerOwner;

	// Setup the way we want to draw all HUD elements
	Canvas.Reset();
	Canvas.SpaceX=0;
	Canvas.bNoSmooth = True;

	FontSize = Min(3, HUDScale * Canvas.ClipX/500);
	Scale = (HUDScale * Canvas.ClipX)/1280.0;

	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );

	SolidHUDColor = FavoriteHUDColor * 15.9;
	if ( (Opacity == 16) || !Level.bHighDetailMode )
	{
		Style = ERenderStyle.STY_Normal;
		BaseColor = WhiteColor;
		HUDColor = SolidHUDColor;
	}
	else
	{
		Style = ERenderStyle.STY_Translucent;
		BaseColor = (16 * Opacity + 15) * UnitColor;
		HUDColor = FavoriteHUDColor * (Opacity + 0.9);
	}
	Canvas.DrawColor = BaseColor;
	Canvas.Style = Style;
	bLowRes = ( Canvas.ClipX < 400 );
	if ( bLowRes )
		WeaponScale = 1.0;
}

simulated function DrawDigit(Canvas Canvas, int d, int Step, float UpScale, out byte bMinus )
{
	if ( bMinus == 1 )
	{
		Canvas.CurX -= Step;
		Canvas.DrawTile(Texture'BotPack.HudElements1', UpScale*25, 64*UpScale, 0, 64, 25.0, 64.0);
		bMinus = 0;
	}
	if ( d == 1 )
		Canvas.CurX -= 0.625 * Step;
	else
		Canvas.CurX -= 0.25 * Step;		
	Canvas.DrawTile(Texture'BotPack.HudElements1', UpScale*25, 64*UpScale, d*25, 0, 25.0, 64.0);
	Canvas.CurX += 7*UpScale;
}

// DrawBigNum should already have Canvas set up
// X and Y should be the left most allowed position of the number (will be adjusted right if possible)
simulated function DrawBigNum(Canvas Canvas, int Value, int X, int Y, optional float ScaleFactor)
{
	local int d, Mag, Step;
	local float UpScale;
	local byte bMinus;

	if ( ScaleFactor != 0 )
		UpScale = Scale * ScaleFactor;
	else
		UpScale = Scale;

	Canvas.CurX = X;	
	Canvas.CurY = Y;
	Step = 16 * UpScale;
	if ( Value < 0 )
		bMinus = 1;
	Mag = FMin(9999, Abs(Value));

	if ( Mag >= 1000 )
	{
		Canvas.CurX -= Step;
		d = 0.001 * Mag;
		DrawDigit(Canvas, d, Step, UpScale, bMinus);
		Mag = Mag - 1000 * d;
		d = 0.01 * Mag;
		DrawDigit(Canvas, d, Step, UpScale, bMinus);
		Mag = Mag - 100 * d;
	}
	else if ( Mag >= 100 )
	{
		d = 0.01 * Mag;
		DrawDigit(Canvas, d, Step, UpScale, bMinus);
		Mag = Mag - 100 * d;
	}
	else
		Canvas.CurX += Step;

	if ( Mag >= 10 )
	{
		d = 0.1 * Mag;
		DrawDigit(Canvas, d, Step, UpScale, bMinus);
		Mag = Mag - 10 * d;
	}
	else if ( d > 0 )
		DrawDigit(Canvas, 0, Step, UpScale, bMinus);
	else
		Canvas.CurX += Step;

	DrawDigit(Canvas, Mag, Step, UpScale, bMinus);
}

simulated function DisplayProgressMessage( canvas Canvas )
{
	local int i;
	local float XL, YL, YOffset;
	local GameReplicationInfo GRI;

	PlayerOwner.ProgressTimeOut = FMin(PlayerOwner.ProgressTimeOut, Level.TimeSeconds + 8);
	Canvas.Style = ERenderStyle.STY_Normal;	

	Canvas.bCenter = True;
	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.StrLen("TEST", XL, YL);
	if ( UTIntro(Level.Game) != None )
		YOffset = 64 * scale + 2 * YL;
	else if ( (MOTDFadeOutTime <= 0) || (Canvas.ClipY < 300) )
		YOffset = 64 * scale + 6 * YL;
	else
	{
		YOffset = 64 * scale + 6 * YL;
		GRI = PlayerOwner.GameReplicationInfo;
		if ( GRI != None )
		{
			if ( GRI.MOTDLine1 != "" )
				YOffset += YL;
			if ( GRI.MOTDLine2 != "" )
				YOffset += YL;
			if ( GRI.MOTDLine3 != "" )
				YOffset += YL;
			if ( GRI.MOTDLine4 != "" )
				YOffset += YL;
		}
	}
	for (i=0; i<8; i++)
	{
		Canvas.SetPos(0, YOffset);
		Canvas.DrawColor = PlayerPawn(Owner).ProgressColor[i];
		Canvas.DrawText(PlayerPawn(Owner).ProgressMessage[i], False);
		YOffset += YL + 1;
	}
	Canvas.DrawColor = WhiteColor;
	Canvas.bCenter = False;
	HUDSetup(Canvas);	
}

//========================================
// Master HUD render function.

simulated function DrawAnimBars(Canvas Canvas)
{
local float XL, YL, X, Y;

	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = BlueColor;

	if ( !bSetStart )
		{
		Speed = 0.01;
		a = 0;
		b = 3.1415926;
		bSetStart = True;
		}

	YL = Canvas.ClipY * 0.5 - 10;
	
	Y = Sin(a);
	Canvas.SetPos( 0, YL + YL * Y);
	Canvas.DrawTile(texture'Tile_Pipe2', Canvas.ClipX, 16, 0, 0, 2, 32);
	Y = Sin(b);
	Canvas.SetPos( 0, YL + YL * Y);
	Canvas.DrawTile(texture'Tile_Pipe2', Canvas.ClipX, 16, 0, 0, 2, 32);	

}

simulated function DrawMaps(Canvas Canvas)
{
local float XL, YL;
local PRI P;

	P = PRI(PlayerPawn(Owner).PlayerReplicationInfo);

	Canvas.bCenter = True;
	Canvas.DrawColor = GoldColor;
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.SetPos( 0, 0 );
	Canvas.DrawText("Top 10 popular maps:", true);

	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.StrLen("TEST", XL, YL);
	Canvas.SetPos( 0, 32 );
	Canvas.DrawText("1st"@P.m1$" ("$P.v1$")", true);
	Canvas.SetPos( 0, 32 + YL );
	Canvas.DrawText("2nd"@P.m2$" ("$P.v2$")", true);
	Canvas.SetPos( 0, 32 + 2 * YL );
	Canvas.DrawText("3rd"@P.m3$" ("$P.v3$")", true);
	Canvas.SetPos( 0, 32 + 3 * YL );
	Canvas.DrawText("4th"@P.m4$" ("$P.v4$")", true);
	Canvas.SetPos( 0, 32 + 4 * YL );
	Canvas.DrawText("5th"@P.m5$" ("$P.v5$")", true);
	Canvas.SetPos( 0, 32 + 5 * YL );
	Canvas.DrawText("6th"@P.m6$" ("$P.v6$")", true);
	Canvas.SetPos( 0, 32 + 6 * YL );
	Canvas.DrawText("7th"@P.m7$" ("$P.v7$")", true);
	Canvas.SetPos( 0, 32 + 7 * YL );
	Canvas.DrawText("8th"@P.m8$" ("$P.v8$")", true);
	Canvas.SetPos( 0, 32 + 8 * YL );
	Canvas.DrawText("9th"@P.m9$" ("$P.v9$")", true);
	Canvas.SetPos( 0, 32 + 9 * YL );
	Canvas.DrawText("10th"@P.m10$" ("$P.v10$")", true);
	Canvas.bCenter = False;
}

simulated function PostRender( canvas Canvas )
{
	local float XL, YL, XPos, YPos, FadeValue;
	local string Message;
	local int M, i, j, k, XOverflow;
	local float OldOriginX;

	
	

	if ( WarningCountDown > 0 || WarningColor.R > 0 )
		{
		DrawWarning(Canvas);
		}

	if ( PRI(PlayerPawn(Owner).PlayerReplicationInfo).m1 != "" && bRenderMaps)
		{
		DrawMaps(Canvas);
		return;
		}

	HUDSetup(canvas);
	if ( (PawnOwner == None) || (PlayerOwner.PlayerReplicationInfo == None) )
		return;

	if ( bShowInfo )
	{
		DrawAnimBars(Canvas);
		DrawStats(Canvas);
		return;
	}

	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	OldOriginX = Canvas.OrgX;
	// Master message short queue control loop.
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.StrLen("TEST", XL, YL);
	Canvas.SetClip(768*Scale - 10, Canvas.ClipY);
	bDrawFaceArea = false;

	for (i=0; i<4; i++)
	{
		if ( ShortMessageQueue[i].Message != None )
		{
			j++;

			if ( bResChanged || (ShortMessageQueue[i].XL == 0) )
			{
				if ( ShortMessageQueue[i].Message.Default.bComplexString )
					Canvas.StrLen(ShortMessageQueue[i].Message.Static.AssembleString( 
											self,
											ShortMessageQueue[i].Switch,
											ShortMessageQueue[i].RelatedPRI,
											ShortMessageQueue[i].StringMessage), 
								   ShortMessageQueue[i].XL, ShortMessageQueue[i].YL);
				else
					Canvas.StrLen(ShortMessageQueue[i].StringMessage, ShortMessageQueue[i].XL, ShortMessageQueue[i].YL);
				Canvas.StrLen("TEST", XL, YL);
				ShortMessageQueue[i].numLines = 1;
				if ( ShortMessageQueue[i].YL > YL )
				{
					ShortMessageQueue[i].numLines++;
					for (k=2; k<4-i; k++)
					{
						if (ShortMessageQueue[i].YL > YL*k)
							ShortMessageQueue[i].numLines++;
					}
				}
			}

			// Keep track of the amount of lines a message overflows, to offset the next message with.
			Canvas.SetPos(6, 2 + YL * YPos);
			YPos += ShortMessageQueue[i].numLines;
			if ( YPos > 4 )
				break; 

			if ( ShortMessageQueue[i].Message.Default.bComplexString )
			{
				// Use this for string messages with multiple colors.
				ShortMessageQueue[i].Message.Static.RenderComplexMessage( 
					Canvas,
					ShortMessageQueue[i].XL,  YL,
					ShortMessageQueue[i].StringMessage,
					ShortMessageQueue[i].Switch,
					ShortMessageQueue[i].RelatedPRI,
					None,
					ShortMessageQueue[i].OptionalObject
					);				
			} 
			else
			{
				Canvas.DrawColor = ShortMessageQueue[i].Message.Default.DrawColor;
				Canvas.DrawText(ShortMessageQueue[i].StringMessage, False);
			}
		}
	}

	Canvas.DrawColor = WhiteColor;
	Canvas.SetClip(OldClipX, Canvas.ClipY);
	Canvas.SetOrigin(OldOriginX, Canvas.OrgY);

	if ( PlayerOwner.bShowScores || bForceScores )
	{
		if ( (PlayerOwner.Scoring == None) && (PlayerOwner.ScoringType != None) )
			PlayerOwner.Scoring = Spawn(PlayerOwner.ScoringType, PlayerOwner);
		if ( PlayerOwner.Scoring != None )
		{ 
			PlayerOwner.Scoring.OwnerHUD = self;
			PlayerOwner.Scoring.ShowScores(Canvas);
			if ( PlayerOwner.Player.Console.bTyping )
				DrawTypingPrompt(Canvas, PlayerOwner.Player.Console);
			return;
		}
	}

	YPos = FMax(YL*4 + 8, 70*Scale);

	if (j > 0) 
	{
		bDrawMessageArea = True;
		MessageFadeCount = 2;
	} 
	else 
		bDrawMessageArea = False;

	if ( !bHideCenterMessages )
	{
		// Master localized message control loop.
		for (i=0; i<10; i++)
		{
			if (LocalMessages[i].Message != None)
			{
				if (LocalMessages[i].Message.Default.bFadeMessage && Level.bHighDetailMode)
				{
					Canvas.Style = ERenderStyle.STY_Translucent;
					FadeValue = (LocalMessages[i].EndOfLife - Level.TimeSeconds);
					if (FadeValue > 0.0)
					{
						if ( bResChanged || (LocalMessages[i].XL == 0) )
						{
							if ( LocalMessages[i].Message.Static.GetFontSize(LocalMessages[i].Switch) == 1 )
								LocalMessages[i].StringFont = MyFonts.GetBigFont( Canvas.ClipX );
							else // ==2
								LocalMessages[i].StringFont = MyFonts.GetHugeFont( Canvas.ClipX );
							Canvas.Font = LocalMessages[i].StringFont;
							Canvas.StrLen(LocalMessages[i].StringMessage, LocalMessages[i].XL, LocalMessages[i].YL);
							LocalMessages[i].YPos = LocalMessages[i].Message.Static.GetOffset(LocalMessages[i].Switch, LocalMessages[i].YL, Canvas.ClipY);
						}
						Canvas.Font = LocalMessages[i].StringFont;
						Canvas.DrawColor = LocalMessages[i].DrawColor * (FadeValue/LocalMessages[i].LifeTime);
						Canvas.SetPos( 0.5 * (Canvas.ClipX - LocalMessages[i].XL), LocalMessages[i].YPos );
						Canvas.DrawText( LocalMessages[i].StringMessage, False );
					}
				} 
				else 
				{
					if ( bResChanged || (LocalMessages[i].XL == 0) )
					{
						if ( LocalMessages[i].Message.Static.GetFontSize(LocalMessages[i].Switch) == 1 )
							LocalMessages[i].StringFont = MyFonts.GetBigFont( Canvas.ClipX );
						else // == 2
							LocalMessages[i].StringFont = MyFonts.GetHugeFont( Canvas.ClipX );
						Canvas.Font = LocalMessages[i].StringFont;
						Canvas.StrLen(LocalMessages[i].StringMessage, LocalMessages[i].XL, LocalMessages[i].YL);
						LocalMessages[i].YPos = LocalMessages[i].Message.Static.GetOffset(LocalMessages[i].Switch, LocalMessages[i].YL, Canvas.ClipY);
					}
					Canvas.Font = LocalMessages[i].StringFont;
					Canvas.Style = ERenderStyle.STY_Normal;
					Canvas.DrawColor = LocalMessages[i].DrawColor;
					Canvas.SetPos( 0.5 * (Canvas.ClipX - LocalMessages[i].XL), LocalMessages[i].YPos );
					Canvas.DrawText( LocalMessages[i].StringMessage, False );
				}
			}
		}
	}
	Canvas.Style = ERenderStyle.STY_Normal;

	if ( !PlayerOwner.bBehindView && (PawnOwner.Weapon != None) && (Level.LevelAction == LEVACT_None) )
	{
		Canvas.DrawColor = WhiteColor;
		PawnOwner.Weapon.PostRender(Canvas);
		if ( !PawnOwner.Weapon.bOwnsCrossHair )
			DrawCrossHair(Canvas, 0,0 );
	}

	if ( (PawnOwner != Owner) && PawnOwner.bIsPlayer )
	{
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		Canvas.bCenter = true;
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.DrawColor = CyanColor * TutIconBlink;
		Canvas.SetPos(4, Canvas.ClipY - 96 * Scale);
		Canvas.DrawText( LiveFeed$PawnOwner.PlayerReplicationInfo.PlayerName, true );
		Canvas.bCenter = false;
		Canvas.DrawColor = WhiteColor;
		Canvas.Style = Style;
	}

	if ( bStartUpMessage && (Level.TimeSeconds < 5) )
	{
		bStartUpMessage = false;
		PlayerOwner.SetProgressTime(7);
	}
	if ( (PlayerOwner.ProgressTimeOut > Level.TimeSeconds) && !bHideCenterMessages )
		DisplayProgressMessage(Canvas);

	// Display MOTD
	if ( MOTDFadeOutTime > 0.0 )
		DrawMOTD(Canvas);
		 
	if( !bHideHUD )
	{
		if ( !PawnOwner.PlayerReplicationInfo.bIsSpectator )
		{
			Canvas.Style = Style;



			
		}

		// Display Identification Info
		if ( PawnOwner == PlayerOwner )
			DrawIdentifyInfo(Canvas);

		if ( HUDMutator != None )
			HUDMutator.PostRender(Canvas);

		if ( (PlayerOwner.GameReplicationInfo != None) && (PlayerPawn(Owner).GameReplicationInfo.RemainingTime > 0) ) 
		{
			if ( TimeMessageClass == None )
				TimeMessageClass = class<CriticalEventPlus>(DynamicLoadObject("Botpack.TimeMessage", class'Class'));

			if ( (PlayerOwner.GameReplicationInfo.RemainingTime <= 300)
			  && (PlayerOwner.GameReplicationInfo.RemainingTime != LastReportedTime) )
			{
				LastReportedTime = PlayerOwner.GameReplicationInfo.RemainingTime;
				if ( PlayerOwner.GameReplicationInfo.RemainingTime <= 30 )
				{
					bTimeValid = ( bTimeValid || (PlayerOwner.GameReplicationInfo.RemainingTime > 0) );	
					if ( PlayerOwner.GameReplicationInfo.RemainingTime == 30 )
						TellTime(5);
					else if ( bTimeValid && PlayerOwner.GameReplicationInfo.RemainingTime <= 10 )
						TellTime(16 - PlayerOwner.GameReplicationInfo.RemainingTime);
				}
				else if ( PlayerOwner.GameReplicationInfo.RemainingTime % 60 == 0 )
				{
					M = PlayerOwner.GameReplicationInfo.RemainingTime/60;
					TellTime(5 - M);
				}
			}
		}
	}
	if ( PlayerOwner.Player.Console.bTyping )
		DrawTypingPrompt(Canvas, PlayerOwner.Player.Console);

	if ( PlayerOwner.bBadConnectionAlert && (PlayerOwner.Level.TimeSeconds > 5) )
	{
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(Canvas.ClipX - (64*Scale), Canvas.ClipY / 2);
		Canvas.DrawIcon(texture'DisconnectWarn', Scale);
	}

	//Draw custom stuff:
	if ( PawnOwner.PlayerReplicationInfo == None || PawnOwner.PlayerReplicationInfo.bIsSpectator )
		return;
	SetupElements(Canvas);
	DrawFrags(Canvas);
	DrawDeaths(Canvas);
	DrawHeadShots(Canvas);
	DrawEff(Canvas);
	DrawCurrentWeapon(Canvas);
	DrawAllWeapon(Canvas);
	ShowPlayers(Canvas);
	DrawHealth(Canvas);
	DrawArmor(Canvas);
}

simulated function DrawWarning(Canvas Canvas)
{
	Canvas.DrawColor = WarningColor;
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 256, Canvas.ClipY * 0.5 - 160);
	Canvas.DrawTile(texture'Warning', 512, 320, 0, 0, 512, 320);
}

simulated function DrawStats(Canvas Canvas)
{
local float XL, YL, Ypos, Xsize, Ysize;
local PRI P;

	P = PRI(PlayerPawn(Owner).PlayerReplicationInfo);

	Xsize = Canvas.ClipX / 1024;
	Ysize = Canvas.ClipY / 666;

	Canvas.DrawColor = BlueColor;
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(0, 0);
	Canvas.DrawTile(texture'scroll', 1024 * Xsize, 666 * Ysize, 0, 0, 1024, 666);

	Canvas.DrawColor = GoldColor;
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.bCenter = True;
	Canvas.Font = MyFonts.GetHugeFont( Canvas.ClipX );
	Canvas.SetPos( 0, 0 );
	Canvas.DrawText("Top 20 players of the server!", true);
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.StrLen("TEST", XL, YL);
	Ypos = Canvas.ClipY * 0.5 - 10 * YL;
	Canvas.SetPos( 0, Ypos );
	Canvas.DrawText("1st"@P.Player1$", Score:"@P.Score1$", Deaths:"@P.Deaths1$", Games:"@P.Games1$", Eff:"@int( float(P.Score1) / ( P.Score1 + P.Deaths1) * 100)$"%"$", Headshots:"@P.topHeadShots1$", Telefrags:"@P.topTelefrags1$", Suicides:"@P.topSuicides1, true);
	Ypos += YL;
	Canvas.SetPos( 0, Ypos );
	Canvas.DrawText("2nd"@P.Player2$", Score:"@P.Score2$", Deaths:"@P.Deaths2$", Games:"@P.Games2$", Eff:"@int( float(P.Score2) / ( P.Score2 + P.Deaths2) * 100)$"%"$", Headshots:"@P.topHeadShots2$", Telefrags:"@P.topTelefrags2$", Suicides:"@P.topSuicides2, true);
	Ypos += YL;
	Canvas.SetPos( 0, Ypos );
	Canvas.DrawText("3rd"@P.Player3$", Score:"@P.Score3$", Deaths:"@P.Deaths3$", Games:"@P.Games3$", Eff:"@int( float(P.Score3) / ( P.Score3 + P.Deaths3) * 100)$"%"$", Headshots:"@P.topHeadShots3$", Telefrags:"@P.topTelefrags3$", Suicides:"@P.topSuicides3, true);
	Ypos += YL;
	Canvas.SetPos( 0, Ypos );
	Canvas.DrawText("4th"@P.Player4$", Score:"@P.Score4$", Deaths:"@P.Deaths4$", Games:"@P.Games4$", Eff:"@int( float(P.Score4) / ( P.Score4 + P.Deaths4) * 100)$"%"$", Headshots:"@P.topHeadShots4$", Telefrags:"@P.topTelefrags4$", Suicides:"@P.topSuicides4, true);
	Ypos += YL;
	Canvas.SetPos( 0, Ypos );
	Canvas.DrawText("5th"@P.Player5$", Score:"@P.Score5$", Deaths:"@P.Deaths5$", Games:"@P.Games5$", Eff:"@int( float(P.Score5) / ( P.Score5 + P.Deaths5) * 100)$"%"$", Headshots:"@P.topHeadShots5$", Telefrags:"@P.topTelefrags5$", Suicides:"@P.topSuicides5, true);
	Ypos += YL;
	Canvas.SetPos( 0, Ypos );
	Canvas.DrawText("6th"@P.Player6$", Score:"@P.Score6$", Deaths:"@P.Deaths6$", Games:"@P.Games6$", Eff:"@int( float(P.Score6) / ( P.Score6 + P.Deaths6) * 100)$"%"$", Headshots:"@P.topHeadShots6$", Telefrags:"@P.topTelefrags6$", Suicides:"@P.topSuicides6, true);
	Ypos += YL;
	Canvas.SetPos( 0, Ypos );
	Canvas.DrawText("7th"@P.Player7$", Score:"@P.Score7$", Deaths:"@P.Deaths7$", Games:"@P.Games7$", Eff:"@int( float(P.Score7) / ( P.Score7 + P.Deaths7) * 100)$"%"$", Headshots:"@P.topHeadShots7$", Telefrags:"@P.topTelefrags7$", Suicides:"@P.topSuicides7, true);
	Ypos += YL;
	Canvas.SetPos( 0, Ypos );
	Canvas.DrawText("8th"@P.Player8$", Score:"@P.Score8$", Deaths:"@P.Deaths8$", Games:"@P.Games8$", Eff:"@int( float(P.Score8) / ( P.Score8 + P.Deaths8) * 100)$"%"$", Headshots:"@P.topHeadShots8$", Telefrags:"@P.topTelefrags8$", Suicides:"@P.topSuicides8, true);
	Ypos += YL;
	Canvas.SetPos( 0, Ypos );
	Canvas.DrawText("9th"@P.Player9$", Score:"@P.Score9$", Deaths:"@P.Deaths9$", Games:"@P.Games9$", Eff:"@int( float(P.Score9) / ( P.Score9 + P.Deaths9) * 100)$"%"$", Headshots:"@P.topHeadShots9$", Telefrags:"@P.topTelefrags9$", Suicides:"@P.topSuicides9, true);
	Ypos += YL;
	Canvas.SetPos( 0, Ypos );
	Canvas.DrawText("10th"@P.Player10$", Score:"@P.Score10$", Deaths:"@P.Deaths10$", Games:"@P.Games10$", Eff:"@int( float(P.Score10) / ( P.Score10 + P.Deaths10) * 100)$"%"$", Headshots:"@P.topHeadShots10$", Telefrags:"@P.topTelefrags10$", Suicides:"@P.topSuicides10, true);
	Ypos += YL;
	Canvas.SetPos( 0, Ypos );
	Canvas.DrawText("11th"@P.Player11$", Score:"@P.Score11$", Deaths:"@P.Deaths11$", Games:"@P.Games11$", Eff:"@int( float(P.Score11) / ( P.Score11 + P.Deaths11) * 100)$"%"$", Headshots:"@P.topHeadShots11$", Telefrags:"@P.topTelefrags11$", Suicides:"@P.topSuicides11, true);
	Ypos += YL;
	Canvas.SetPos( 0, Ypos );
	Canvas.DrawText("12th"@P.Player12$", Score:"@P.Score12$", Deaths:"@P.Deaths12$", Games:"@P.Games12$", Eff:"@int( float(P.Score12) / ( P.Score12 + P.Deaths12) * 100)$"%"$", Headshots:"@P.topHeadShots12$", Telefrags:"@P.topTelefrags12$", Suicides:"@P.topSuicides12, true);
	Ypos += YL;
	Canvas.SetPos( 0, Ypos );
	Canvas.DrawText("13th"@P.Player13$", Score:"@P.Score13$", Deaths:"@P.Deaths13$", Games:"@P.Games13$", Eff:"@int( float(P.Score13) / ( P.Score13 + P.Deaths13) * 100)$"%"$", Headshots:"@P.topHeadShots13$", Telefrags:"@P.topTelefrags13$", Suicides:"@P.topSuicides13, true);
	Ypos += YL;
	Canvas.SetPos( 0, Ypos );
	Canvas.DrawText("14th"@P.Player14$", Score:"@P.Score14$", Deaths:"@P.Deaths14$", Games:"@P.Games14$", Eff:"@int( float(P.Score14) / ( P.Score14 + P.Deaths14) * 100)$"%"$", Headshots:"@P.topHeadShots14$", Telefrags:"@P.topTelefrags14$", Suicides:"@P.topSuicides14, true);
	Ypos += YL;
	Canvas.SetPos( 0, Ypos );
	Canvas.DrawText("15th"@P.Player15$", Score:"@P.Score15$", Deaths:"@P.Deaths15$", Games:"@P.Games15$", Eff:"@int( float(P.Score15) / ( P.Score15 + P.Deaths15) * 100)$"%"$", Headshots:"@P.topHeadShots15$", Telefrags:"@P.topTelefrags15$", Suicides:"@P.topSuicides15, true);
	Ypos += YL;
	Canvas.SetPos( 0, Ypos );
	Canvas.DrawText("16th"@P.Player16$", Score:"@P.Score16$", Deaths:"@P.Deaths16$", Games:"@P.Games16$", Eff:"@int( float(P.Score16) / ( P.Score16 + P.Deaths16) * 100)$"%"$", Headshots:"@P.topHeadShots16$", Telefrags:"@P.topTelefrags16$", Suicides:"@P.topSuicides16, true);
	Ypos += YL;
	Canvas.SetPos( 0, Ypos );
	Canvas.DrawText("17th"@P.Player17$", Score:"@P.Score17$", Deaths:"@P.Deaths17$", Games:"@P.Games17$", Eff:"@int( float(P.Score17) / ( P.Score17 + P.Deaths17) * 100)$"%"$", Headshots:"@P.topHeadShots17$", Telefrags:"@P.topTelefrags17$", Suicides:"@P.topSuicides17, true);
	Ypos += YL;
	Canvas.SetPos( 0, Ypos );
	Canvas.DrawText("18th"@P.Player18$", Score:"@P.Score18$", Deaths:"@P.Deaths18$", Games:"@P.Games18$", Eff:"@int( float(P.Score18) / ( P.Score18 + P.Deaths18) * 100)$"%"$", Headshots:"@P.topHeadShots18$", Telefrags:"@P.topTelefrags18$", Suicides:"@P.topSuicides18, true);
	Ypos += YL;
	Canvas.SetPos( 0, Ypos );
	Canvas.DrawText("19th"@P.Player19$", Score:"@P.Score19$", Deaths:"@P.Deaths19$", Games:"@P.Games19$", Eff:"@int( float(P.Score19) / ( P.Score19 + P.Deaths19) * 100)$"%"$", Headshots:"@P.topHeadShots19$", Telefrags:"@P.topTelefrags19$", Suicides:"@P.topSuicides19, true);
	Ypos += YL;
	Canvas.SetPos( 0, Ypos );
	Canvas.DrawText("20th"@P.Player20$", Score:"@P.Score20$", Deaths:"@P.Deaths20$", Games:"@P.Games20$", Eff:"@int( float(P.Score20) / ( P.Score20 + P.Deaths20) * 100)$"%"$", Headshots:"@P.topHeadShots20$", Telefrags:"@P.topTelefrags20$", Suicides:"@P.topSuicides20, true);
	Canvas.bCenter = False;
}


function string TwoDigitString(int Num)
{
	if ( Num < 10 )
		return "0"$Num;
	else
		return string(Num);
}

simulated function SetupElements(Canvas Canvas)
{
local float XL, YL;
local int Hours, Minutes, Seconds;

	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = WhiteColor;
	Canvas.Font = MyFonts.GetSmallestFont( Canvas.ClipX );
	canvas.bCenter = True;
	Canvas.SetPos(0, 0 );
	Canvas.DrawText("Hit F2 to show top 20 players", true);
	Canvas.DrawColor = GrayColor;
	canvas.bCenter = False;
	Canvas.SetPos(0, Canvas.ClipY - 64);
	Canvas.DrawTile(texture'Tile_Background', Canvas.ClipX, 64, 0, 0, Canvas.ClipX, 128);
	Canvas.SetPos(Canvas.ClipX - 128,0 );
	Canvas.DrawTile(texture'Icon_Monitor', 128, 96, 0, 0, 128, 128);
	Canvas.SetPos(Canvas.ClipX - 128,Canvas.ClipY - 160 );
	Canvas.DrawTile(texture'Icon_Time', 128, 96, 0, 0, 128, 128);

	//Draw Date and Time:
	Canvas.DrawColor = WhiteColor;
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.StrLen(Level.Day$"-"$Level.Month$"-"$Level.Year, XL, YL);
	Canvas.SetPos(Canvas.ClipX - 64 - 0.5 * XL, 15 );
	Canvas.DrawText(Level.Day$"-"$Level.Month$"-"$Level.Year, true);
	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.StrLen(TwoDigitString(Level.Hour)$":"$TwoDigitString(Level.Minute)$":"$TwoDigitString(Level.Second), XL, YL);
	Canvas.SetPos(Canvas.ClipX - 64 - 0.5 * XL, 35 );
	Canvas.DrawText(TwoDigitString(Level.Hour)$":"$TwoDigitString(Level.Minute)$":"$TwoDigitString(Level.Second), true);

	//Draw Game Time:
	Canvas.DrawColor = WhiteColor;
	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Seconds = PlayerPawn(Owner).GameReplicationInfo.ElapsedTime;
	if ( bTimeDown || (PlayerPawn(Owner).GameReplicationInfo.RemainingTime > 0) )
		{
		bTimeDown = true;
		if ( PlayerPawn(Owner).GameReplicationInfo.RemainingTime <= 0 )
			{
			Canvas.StrLen("00:00", XL, YL);
			Canvas.SetPos(Canvas.ClipX - 64 - 0.5 * XL, Canvas.ClipY - 144 );
			Canvas.DrawText("00:00", true);
			}
		else
			{
			Minutes = PlayerPawn(Owner).GameReplicationInfo.RemainingTime/60;
			Seconds = PlayerPawn(Owner).GameReplicationInfo.RemainingTime % 60;
			Canvas.StrLen(TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), XL, YL);
			Canvas.SetPos(Canvas.ClipX - 64 - 0.5 * XL, Canvas.ClipY - 144 );
			Canvas.DrawText(TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
			}
		}
	else
		{
		Minutes = Seconds / 60;
		Hours   = Minutes / 60;
		Seconds = Seconds - (Minutes * 60);
		Minutes = Minutes - (Hours * 60);
		Canvas.StrLen(TwoDigitString(Hours)$":"$TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), XL, YL);
		Canvas.SetPos(Canvas.ClipX - 64 - 0.5 * XL, Canvas.ClipY - 144 );
		Canvas.DrawText(TwoDigitString(Hours)$":"$TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
		}
}

simulated function DrawFrags(Canvas Canvas)
{
local float XL, YL;
local int Score;

	Score = int(Pawn(Owner).PlayerReplicationInfo.Score);

	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.StrLen(Score, XL, YL);
	Canvas.DrawColor = RedColor;
	Canvas.SetPos(0, Canvas.ClipY - 64);
	Canvas.DrawTile(texture'Icon_Skull', 64, 64, 0, 0, 128, 128);
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.SetPos(33 - 0.5 * XL, Canvas.ClipY - 43);
	Canvas.DrawColor.R = 80;
	Canvas.DrawColor.G = 80;
	Canvas.DrawColor.B = 80;
	Canvas.DrawText(Score, true);
	Canvas.SetPos(32 - 0.5 * XL, Canvas.ClipY - 42);
	Canvas.DrawColor = WhiteColor;
	Canvas.DrawText(Score, true);

}

simulated function DrawDeaths(Canvas Canvas)
{
local float XL, YL;
local int Deaths;

	Deaths = int(Pawn(Owner).PlayerReplicationInfo.Deaths);

	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.StrLen(Deaths, XL, YL);
	Canvas.DrawColor = RedColor;
	Canvas.SetPos(64, Canvas.ClipY - 64);
	Canvas.DrawTile(texture'tombstone', 64, 64, 0, 0, 128, 128);
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.SetPos(97 - 0.5 * XL, Canvas.ClipY - 43);
	Canvas.DrawColor.R = 80;
	Canvas.DrawColor.G = 80;
	Canvas.DrawColor.B = 80;
	Canvas.DrawText(Deaths, true);
	Canvas.SetPos(96 - 0.5 * XL, Canvas.ClipY - 42);
	Canvas.DrawColor = WhiteColor;
	Canvas.DrawText(Deaths, true);
}

simulated function DrawHeadShots(Canvas Canvas)
{
local float XL, YL;
local int hs;

	hs = PRI(PlayerPawn(Owner).PlayerReplicationInfo).Headshots;

	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.StrLen(hs, XL, YL);
	Canvas.DrawColor = RedColor;
	Canvas.SetPos(128, Canvas.ClipY - 64);
	Canvas.DrawTile(texture'HSskull', 64, 64, 0, 0, 128, 128);
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.SetPos(161 - 0.5 * XL, Canvas.ClipY - 43);
	Canvas.DrawColor.R = 80;
	Canvas.DrawColor.G = 80;
	Canvas.DrawColor.B = 80;
	Canvas.DrawText(hs, true);
	Canvas.SetPos(160 - 0.5 * XL, Canvas.ClipY - 42);
	Canvas.DrawColor = WhiteColor;
	Canvas.DrawText(hs, true);
}

simulated function DrawHealth(Canvas Canvas)
{
local float XL, YL;
local int Health;

	Health = Pawn(Owner).Health;

	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.StrLen(Health, XL, YL);
	if ( Health > 59 )
		Canvas.DrawColor = GreenColor;
	else if ( Health > 29 )
		Canvas.DrawColor = GoldColor;
	else
		{
		Canvas.DrawColor.R = HealthColor;
		Canvas.DrawColor.G = 0;
		Canvas.DrawColor.B = 0;
		}
	Canvas.SetPos(Canvas.ClipX - 64, Canvas.ClipY - 64);
	Canvas.DrawTile(texture'Icon_Health', 64, 64, 0, 0, 128, 128);
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.SetPos(Canvas.ClipX - 32 - 0.5 * XL, Canvas.ClipY - 43);
	Canvas.DrawColor.R = 80;
	Canvas.DrawColor.G = 80;
	Canvas.DrawColor.B = 80;
	Canvas.DrawText(Health, true);
	Canvas.SetPos(Canvas.ClipX - 31 - 0.5 * XL, Canvas.ClipY - 42);
	Canvas.DrawColor = WhiteColor;
	Canvas.DrawText(Health, true);
}

simulated function DrawArmor(Canvas Canvas)
{
local float XL, YL;
local int Armor, Boots;
local Inventory Inv;
local bool bShieldBelt;

	for( Inv=PawnOwner.Inventory; Inv!=None; Inv=Inv.Inventory )
		{ 
		if ( Inv.bIsAnArmor )
			{
			if ( Inv.IsA('Armor2') )
				Armor += Inv.Charge;
			else if ( Inv.IsA('ThighPads') )
				Armor += Inv.Charge;
			else if ( Inv.IsA('UT_ShieldBelt') )
				{
				Armor += Inv.Charge;
				bShieldBelt = True;
				}	
			}
		else if ( Inv.IsA('UT_Jumpboots') )
			Boots += Inv.Charge;
		}
	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.StrLen(Armor, XL, YL);
	Canvas.DrawColor = RedColor;
	Canvas.SetPos(Canvas.ClipX - 128, Canvas.ClipY - 64);
	if ( bShieldBelt )
		Canvas.DrawTile(texture'Icon_ArmorSB', 64, 64, 0, 0, 128, 128);
	else
		Canvas.DrawTile(texture'Icon_Armor', 64, 64, 0, 0, 128, 128);
	if ( Armor > 0 )
		{
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.SetPos(Canvas.ClipX - 96 - 0.5 * XL, Canvas.ClipY - 43);
		Canvas.DrawColor.R = 80;
		Canvas.DrawColor.G = 80;
		Canvas.DrawColor.B = 80;
		Canvas.DrawText(Armor, true);
		Canvas.SetPos(Canvas.ClipX - 95 - 0.5 * XL, Canvas.ClipY - 42);
		Canvas.DrawColor = WhiteColor;
		Canvas.DrawText(Armor, true);
		}
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.StrLen(Boots, XL, YL);
	Canvas.DrawColor = RedColor;
	Canvas.SetPos(Canvas.ClipX - 192, Canvas.ClipY - 64);
	Canvas.DrawTile(texture'Icon_Boots', 64, 64, 0, 0, 128, 128);
	if ( Boots > 0 )
		{
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.SetPos(Canvas.ClipX - 160 - 0.5 * XL, Canvas.ClipY - 43);
		Canvas.DrawColor.R = 80;
		Canvas.DrawColor.G = 80;
		Canvas.DrawColor.B = 80;
		Canvas.DrawText(Boots, true);
		Canvas.SetPos(Canvas.ClipX - 159 - 0.5 * XL, Canvas.ClipY - 42);
		Canvas.DrawColor = WhiteColor;
		Canvas.DrawText(Boots, true);
		}
}

simulated function DrawEff(Canvas Canvas)
{
local float XL, YL;
local float Score, Deaths;
local int Eff;

	Score = Pawn(Owner).PlayerReplicationInfo.Score;
	Deaths = Pawn(Owner).PlayerReplicationInfo.Deaths;

	if ( Score < 0 )
		Score = 0;

	Eff = Score / (Score + Deaths) * 100;


	Canvas.Font = MyFonts.GetSmallestFont( Canvas.ClipX );
	Canvas.StrLen(Eff$"%", XL, YL);
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.SetPos(61 - 0.5 * XL, Canvas.ClipY - 3.75 * YL + 1);
	Canvas.DrawColor.R = 20;
	Canvas.DrawColor.G = 20;
	Canvas.DrawColor.B = 20;
	Canvas.DrawText(Eff$"%", true);
	Canvas.SetPos(60 - 0.5 * XL, Canvas.ClipY - 3.75 * YL );
	if ( Eff == 100 )
		Canvas.DrawColor = WhiteColor;
	else if ( Eff > 66 )
		Canvas.DrawColor = GreenColor;
	else if ( Eff > 33 )
		Canvas.DrawColor = GoldColor;
	else
		Canvas.DrawColor = RedColor;
	Canvas.DrawText(Eff$"%", true);
}

simulated function DrawCurrentWeapon(Canvas Canvas)
{
local string Weapon;
local int Ammo;

	if ( Pawn(Owner).Weapon != None )
		{
		Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
		Canvas.Style = ERenderStyle.STY_Normal;
		Weapon = Pawn(Owner).Weapon.ItemName;
		Canvas.bCenter = True;
		Canvas.SetPos(1, Canvas.ClipY - 60);
		Canvas.DrawColor.R = 20;
		Canvas.DrawColor.G = 20;
		Canvas.DrawColor.B = 20;
		Canvas.DrawText(Weapon, true);
		Canvas.SetPos(0, Canvas.ClipY - 61 );
		Canvas.DrawColor = WhiteColor;
		Canvas.DrawText(Weapon, true);
		if ( Pawn(Owner).Weapon.AmmoType != None )
			{
			Ammo = Pawn(Owner).Weapon.AmmoType.AmmoAmount;
			Canvas.DrawColor.R = 20;
			Canvas.DrawColor.G = 20;
			Canvas.DrawColor.B = 20;
			Canvas.SetPos(1, Canvas.ClipY - 39);
			Canvas.DrawText(Ammo, true);
			Canvas.DrawColor = WhiteColor;
			Canvas.SetPos(0, Canvas.ClipY - 40 );
			Canvas.DrawText(Ammo, true);
			}
		Canvas.bCenter = False;
		}
}

simulated function DrawAllWeapon(Canvas Canvas)
{
local string Weapons;
local Inventory Inv;
local int num;

	Weapons = "";
	num = 0;

	for( Inv=PawnOwner.Inventory; Inv!=None; Inv=Inv.Inventory )
		{ 
		if ( Inv.IsA('Weapon') ) 
			{
			if ( num == 0 )
				{
				if ( Weapon(Inv).AmmoType != None && Weapon(Inv).AmmoType.AmmoAmount > 0 )
					{
					Weapons = Weapon(Inv).ItemName$"("$Weapon(Inv).AmmoType.AmmoAmount$")";
					}
				else
					{
					Weapons = Weapon(Inv).ItemName;
					}
				num = 100;
				}
			else if ( Weapon(Inv).AmmoType != None && ( Weapon(Inv).AmmoType.AmmoAmount > 0 || Inv.IsA('ChainSaw') || Inv.IsA('ImpactHammer') || Inv.IsA('Translocator') ) )
				{
				if ( Weapon(Inv).AmmoType != None && Weapon(Inv).AmmoType.AmmoAmount > 0 )
					{
					Weapons = Weapons$" -"@Weapon(Inv).ItemName$"("$Weapon(Inv).AmmoType.AmmoAmount$")";
					}
				else
					{
					Weapons = Weapons$" -"@Weapon(Inv).ItemName;
					}
				}
			}
		}
	Canvas.Font = MyFonts.GetAReallySmallFont( Canvas.ClipX );
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.bCenter = True;
	Canvas.SetPos(1, Canvas.ClipY - 16);
	Canvas.DrawColor.R = 20;
	Canvas.DrawColor.G = 20;
	Canvas.DrawColor.B = 20;
	Canvas.DrawText(Weapons, true);
	Canvas.SetPos(0, Canvas.ClipY - 17 );
	Canvas.DrawColor = WhiteColor;
	Canvas.DrawText(Weapons, true);
	Canvas.bCenter = False;
		
}

function DrawRankedPlayers(Int ID, Canvas Canvas, PlayerReplicationInfo PRI, float XOffset, float YOffset, bool bCompressed)
{
local float XL, YL, XL2, YL2, XL3, YL3;
local Font CanvasFont;
local bool bLocalPlayer;
local PlayerPawn PlayerOwner;
local int Time;

	Canvas.Font = MyFonts.GetSmallestFont( Canvas.ClipX );
	PlayerOwner = PlayerPawn(Owner);

	bLocalPlayer = (PRI.PlayerName == PlayerOwner.PlayerReplicationInfo.PlayerName);

	if ( bLocalPlayer ) 
		Canvas.DrawColor = GoldColor;
	else 
		Canvas.DrawColor = GreenColor;

	Canvas.SetPos(0, YOffset);
	Canvas.DrawText(ID+1@PRI.PlayerName$","@int(PRI.Score), False);
	
}

function ShowPlayers( canvas Canvas )
{
local PlayerReplicationInfo PRI;
local int u, i;
local float XL, YL, Scale;
local float YOffset, YStart;
//local font CanvasFont;

	Canvas.Font = MyFonts.GetSmallestFont( Canvas.ClipX );
	Canvas.StrLen( "0000", XL, YL );
	YOffset = Canvas.ClipY * 0.5 - 0.5 * YL * PlayerCount;

	PlayerCount = 0;

	// Wipe everything.
	for ( i=0; i<ArrayCount(Ordered); i++ )
		Ordered[i] = None;
	for ( i=0; i<32; i++ )
		{
		if (PlayerPawn(Owner).GameReplicationInfo.PRIArray[i] != None)
			{
			PRI = PlayerPawn(Owner).GameReplicationInfo.PRIArray[i];
			if ( !PRI.bIsSpectator || PRI.bWaitingPlayer )
				{
				Ordered[u] = PRI;
				u++;
				PlayerCount++;
				if ( u == ArrayCount(Ordered) )
					break;
				}
			}
		}
	SortScores(PlayerCount);
	
	for ( I=0; I<PlayerCount; I++ )
		{
		DrawRankedPlayers(I, Canvas, Ordered[I], 0, YOffset, false );
		YOffset += YL;
		}
	
}

function SortScores(int N)
{
	local int I, J, Max;
	local PlayerReplicationInfo TempPRI;
	
	for ( I=0; I<N-1; I++ )
	{
		Max = I;
		for ( J=I+1; J<N; J++ )
		{
			if ( Ordered[J].Score > Ordered[Max].Score )
				Max = J;
			else if ((Ordered[J].Score == Ordered[Max].Score) && (Ordered[J].Deaths < Ordered[Max].Deaths))
				Max = J;
			else if ((Ordered[J].Score == Ordered[Max].Score) && (Ordered[J].Deaths == Ordered[Max].Deaths) &&
					 (Ordered[J].PlayerID < Ordered[Max].Score))
				Max = J;
		}

		TempPRI = Ordered[Max];
		Ordered[Max] = Ordered[I];
		Ordered[I] = TempPRI;
	}
}

function Timer()
{
	local int i, j;

	if (!bDrawMessageArea)
	{
		if (MessageFadeCount > 0)
			MessageFadeCount--;
	}

	// Age the short message queue.
	for (i=0; i<4; i++)
	{
		// Purge expired messages.
		if ( (ShortMessageQueue[i].Message != None) && (Level.TimeSeconds >= ShortMessageQueue[i].EndOfLife) )
			ClearMessage(ShortMessageQueue[i]);
	}

	// Clean empty slots.
	for (i=0; i<3; i++)
	{
		if ( ShortMessageQueue[i].Message == None )
		{
			for (j=i; j<4; j++)
			{
				if ( ShortMessageQueue[j].Message != None )
				{
					CopyMessage(ShortMessageQueue[i],ShortMessageQueue[j]);
					ClearMessage(ShortMessageQueue[j]);
					break;
				}
			}
		}
	}

	// Age all localized messages.
	for (i=0; i<10; i++)
	{
		// Purge expired messages.
		if ( (LocalMessages[i].Message != None) && (Level.TimeSeconds >= LocalMessages[i].EndOfLife) )
			ClearMessage(LocalMessages[i]);
	}

	// Clean empty slots.
	for (i=0; i<9; i++)
	{
		if ( LocalMessages[i].Message == None )
		{
			CopyMessage(LocalMessages[i],LocalMessages[i+1]);
			ClearMessage(LocalMessages[i+1]);
		}
	}

	if ( (PlayerOwner == None) || (PawnOwner == None) || (PlayerOwner.GameReplicationInfo == None)
		|| (PawnOwner.PlayerReplicationInfo == None) )
		return;

}

simulated function TellTime(int num)
{
	PlayerOwner.ReceiveLocalizedMessage( TimeMessageClass, Num );
}

simulated function Tick(float DeltaTime)
{
	local int i;

	Super.Tick(DeltaTime);

	if ( WarningCountDown > 0 || WarningColor.R > 0 )
		{
		//DrawWarning(Canvas);
		WarningCountDown--;
		if ( WarningCountDown < 0 )
			{
			WarningColor.R -= 1;
			WarningColor.G -= 1;
			WarningColor.B -= 1;
			}
		}

	if ( PRI(PlayerPawn(Owner).PlayerReplicationInfo).m1 != "" && bRenderMaps)
		{
		MapsCountDown--;
		if ( MapsCountDown < 0 )
			bRenderMaps = False;
		}

	IdentifyFadeTime = FMax(0.0, IdentifyFadeTime - DeltaTime);
	MOTDFadeOutTime = FMax(0.0, MOTDFadeOutTime - DeltaTime * 55);
	
	TutIconBlink += DeltaTime;
	if (TutIconBlink >= 0.5)
		TutIconBlink = 0.0;

	if ( bDrawFaceArea )
	{
		if ( FaceAreaOffset < 0 )
			FaceAreaOffset += DeltaTime * 600;
		if ( FaceAreaOffset > 0 )
			FaceAreaOffset = 0.0;
	} 
	else if ( FaceAreaOffset > MinFaceAreaOffset )
		FaceAreaOffset = FMax(FaceAreaOffset - DeltaTime * 600, MinFaceAreaOffset );

	if ( bDrawMessageArea )
	{
		if ( MessageFadeTime < 1.0 )
		{
			MessageFadeTime += DeltaTime * 8;
			if (MessageFadeTime > 1.0)
				MessageFadeTime = 1.0;
		}
	} 
	else if ( (MessageFadeTime > 0.0) && (MessageFadeCount == 0) )
	{
		MessageFadeTime -= DeltaTime * 2;
		if (MessageFadeTime < 0.0)
			MessageFadeTime = 0.0;
	}

	a -= Speed;
	if ( a < 0 )
		{
		a = 6.283185307;
		}
	b -= Speed;
	if ( b < 0 )
		{
		b = 6.283185307;
		}

	HealthColor -=5;
		if ( HealthColor < 0 )
		{
		HealthColor = 255;
		}
}

simulated function DrawMOTD(Canvas Canvas)
{
	local GameReplicationInfo GRI;
	local float XL, YL;
	local float InitialY;

	GRI = PlayerPawn(Owner).GameReplicationInfo;
	if ( (GRI == None) || (GRI.GameName == "Game") || (MOTDFadeOutTime <= 0) ) 
		return;

	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.Style = Style;
	Canvas.bCenter = true;
	Canvas.DrawColor = UnitColor * MOTDFadeOutTime * 0.5;
	InitialY = 64*Scale;
	Canvas.SetPos(0.0, InitialY);
	Canvas.StrLen("TEST", XL, YL);
	if ( Level.NetMode != NM_Standalone )
	{
		Canvas.DrawText(GRI.ServerName);
		if ( Canvas.ClipY >= 300 )
		{
			Canvas.SetPos(0.0, InitialY + 6*YL);
			Canvas.DrawText(GRI.MOTDLine1, true);
			Canvas.SetPos(0.0, InitialY + 7*YL);
			Canvas.DrawText(GRI.MOTDLine2, true);
			Canvas.SetPos(0.0, InitialY + 8*YL);
			Canvas.DrawText(GRI.MOTDLine3, true);
			Canvas.SetPos(0.0, InitialY + 9*YL);
			Canvas.DrawText(GRI.MOTDLine4, true);
		}
	}
	Canvas.DrawColor = UnitColor * MOTDFadeOutTime * 0.6;
	Canvas.SetPos(0.0, InitialY + YL);
	Canvas.DrawText(GRI.GameName, true);
	Canvas.SetPos(0.0, InitialY + 2*YL);
	Canvas.DrawText(MapTitleString2@Level.Title, true);
	if ( Canvas.ClipY >= 300 )
	{
		Canvas.SetPos(0.0, InitialY + 3*YL);
		Canvas.DrawText(AuthorString2@Level.Author, true);
		if (Level.IdealPlayerCount != "")
		{
			Canvas.SetPos(0.0, InitialY + 4*YL);
			Canvas.DrawText(PlayerCountString$Level.IdealPlayerCount, true);
		}
	}
	Canvas.bCenter = false;
}

simulated function DrawCrossHair( canvas Canvas, int X, int Y)
{
	local float XScale, PickDiff;
	local float XLength;
	local texture T;

 	if (Crosshair>=CrosshairCount) Return;
	if ( Canvas.ClipX < 512 )
		XScale = 0.5;
	else
		XScale = FMax(1, int(0.1 + Canvas.ClipX/640.0));
	PickDiff = Level.TimeSeconds - PickupTime;
	if ( PickDiff < 0.4 )
	{
		if ( PickDiff < 0.2 )
			XScale *= (1 + 5 * PickDiff);
		else
			XScale *= (3 - 5 * PickDiff);
	}
	XLength = XScale * 64.0;

	Canvas.bNoSmooth = False;
	if ( PlayerOwner.Handedness == -1 )
		Canvas.SetPos(0.503 * (Canvas.ClipX - XLength), 0.504 * (Canvas.ClipY - XLength));
	else if ( PlayerOwner.Handedness == 1 )
		Canvas.SetPos(0.497 * (Canvas.ClipX - XLength), 0.496 * (Canvas.ClipY - XLength));
	else
		Canvas.SetPos(0.5 * (Canvas.ClipX - XLength), 0.5 * (Canvas.ClipY - XLength));
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = 15 * CrosshairColor;

	T = CrossHairTextures[Crosshair];
	if( T == None )
		T = LoadCrosshair(Crosshair);

	Canvas.DrawTile(T, XLength, XLength, 0, 0, 64, 64);
	Canvas.bNoSmooth = True;
	Canvas.Style = Style;
}

simulated function DrawTypingPrompt( canvas Canvas, console Console )
{
	local string TypingPrompt;
	local float XL, YL, YPos, XOffset;
	local float MyOldClipX, OldClipY, OldOrgX, OldOrgY;

	MyOldClipX = Canvas.ClipX;
	OldClipY = Canvas.ClipY;
	OldOrgX = Canvas.OrgX;
	OldOrgY = Canvas.OrgY;

	Canvas.DrawColor = GreenColor;
	//TypingPrompt = "(>"@Console.TypedStr$"_";
	TypingPrompt = PlayerPawn(Owner).PlayerReplicationInfo.PlayerName$">"@Console.TypedStr$"_";
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.StrLen( "TEST", XL, YL );
	YPos = YL*4 + 8;
	if (PawnOwner.PlayerReplicationInfo.bIsSpectator || bHideHUD || bHideFaces)
		XOffset = 0;
	else
		XOffset = FMax(0,FaceAreaOffset + 15*Scale + YPos);
	Canvas.SetOrigin(XOffset, FMax(0,YPos + 7*Scale));
	Canvas.SetClip( 760*Scale, Canvas.ClipY );
	Canvas.SetPos( 0, 0 );
	Canvas.DrawText( TypingPrompt, false );
	Canvas.SetOrigin( OldOrgX, OldOrgY );
	Canvas.SetClip( MyOldClipX, OldClipY );
}

// Entry point for string messages.
simulated function Message( PlayerReplicationInfo PRI, coerce string Msg, name MsgType )
{
	local int i;
	local Class<LocalMessage> MessageClass;

	switch (MsgType)
	{
		case 'Say':
		case 'TeamSay':
			MessageClass = class'SayMessagePlus';
			break;
		case 'CriticalEvent':
			MessageClass = class'CriticalStringPlus';
			LocalizedMessage( MessageClass, 0, None, None, None, Msg );
			return;
		case 'DeathMessage':
			MessageClass = class'RedSayMessagePlus';
			break;
		case 'Pickup':
			PickupTime = Level.TimeSeconds;
		default:
			MessageClass = class'StringMessagePlus';
			break;
	}

	if ( ClassIsChildOf(MessageClass, class'SayMessagePlus') || 
				     ClassIsChildOf(MessageClass, class'TeamSayMessagePlus') )
	{
		FaceTexture = PRI.TalkTexture;
		if ( FaceTexture != None )
			FaceTime = Level.TimeSeconds + 3;
		if ( Msg == "" )
			return;
	} 
	for (i=0; i<4; i++)
	{
		if ( ShortMessageQueue[i].Message == None )
		{
			// Add the message here.
			ShortMessageQueue[i].Message = MessageClass;
			ShortMessageQueue[i].Switch = 0;
			ShortMessageQueue[i].RelatedPRI = PRI;
			ShortMessageQueue[i].OptionalObject = None;
			ShortMessageQueue[i].EndOfLife = MessageClass.Default.Lifetime + Level.TimeSeconds;
			if ( MessageClass.Default.bComplexString )
				ShortMessageQueue[i].StringMessage = Msg;
			else
				ShortMessageQueue[i].StringMessage = MessageClass.Static.AssembleString(self,0,PRI,Msg);
			return;
		}
	}

	// No empty slots.  Force a message out.
	for (i=0; i<3; i++)
		CopyMessage(ShortMessageQueue[i], ShortMessageQueue[i+1]);

	ShortMessageQueue[3].Message = MessageClass;
	ShortMessageQueue[3].Switch = 0;
	ShortMessageQueue[3].RelatedPRI = PRI;
	ShortMessageQueue[3].OptionalObject = None;
	ShortMessageQueue[3].EndOfLife = MessageClass.Default.Lifetime + Level.TimeSeconds;
	if ( MessageClass.Default.bComplexString )
		ShortMessageQueue[3].StringMessage = Msg;
	else
		ShortMessageQueue[3].StringMessage = MessageClass.Static.AssembleString(self,0,PRI,Msg);
}

simulated function bool DisplayMessages( canvas Canvas )
{
	return true;
}

simulated function float DrawNextMessagePart(Canvas Canvas, string MString, float XOffset, int YPos)
{
	local float XL, YL;

	Canvas.SetPos(4 + XOffset, YPos);
	Canvas.StrLen( MString, XL, YL );
	Canvas.DrawText( MString, false );
	return (XOffset + XL);
}

//================================================================================
// Identify Info

simulated function bool TraceIdentify(canvas Canvas)
{
	local actor Other;
	local vector HitLocation, HitNormal, StartTrace, EndTrace;

	StartTrace = PawnOwner.Location;
	StartTrace.Z += PawnOwner.BaseEyeHeight;
	EndTrace = StartTrace + vector(PawnOwner.ViewRotation) * 1000.0;
	Other = Trace(HitLocation, HitNormal, EndTrace, StartTrace, true);

	if ( Pawn(Other) != None )
	{
		if ( Pawn(Other).bIsPlayer && !Other.bHidden )
		{
			IdentifyTarget = Pawn(Other).PlayerReplicationInfo;
			IdentifyFadeTime = 3.0;
		}
	}
	else if ( (Other != None) && SpecialIdentify(Canvas, Other) )
		return false;

	if ( (IdentifyFadeTime == 0.0) || (IdentifyTarget == None) || IdentifyTarget.bFeigningDeath )
		return false;

	return true;
}

simulated function bool SpecialIdentify(Canvas Canvas, Actor Other )
{
	return false;
}

simulated function SetIDColor( Canvas Canvas, int type )
{
	Canvas.DrawColor = GreenColor;
	if ( type == 0 )
		Canvas.DrawColor.G = 160 * (IdentifyFadeTime / 3.0);
	else
		Canvas.DrawColor.G = 255 * (IdentifyFadeTime / 3.0);
}

simulated function DrawTwoColorID( canvas Canvas, string TitleString, string ValueString, int YStart )
{
	local float XL, YL, XOffset, X1;

	Canvas.Style = Style;
	Canvas.StrLen(TitleString$": ", XL, YL);
	X1 = XL;
	Canvas.StrLen(ValueString, XL, YL);
	XOffset = Canvas.ClipX/2 - (X1+XL)/2;
	Canvas.SetPos(XOffset, YStart);
	SetIDColor(Canvas,0);
	XOffset += X1;
	Canvas.DrawText(TitleString);
	Canvas.SetPos(XOffset, YStart);
	SetIDColor(Canvas,1);
	Canvas.DrawText(ValueString);
	Canvas.DrawColor = WhiteColor;
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
}
	
simulated function bool DrawIdentifyInfo(canvas Canvas)
{
	if ( !TraceIdentify(Canvas))
		return false;

	if( IdentifyTarget.PlayerName != "" )
	{
		Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);
		DrawTwoColorID(Canvas,IdentifyName, IdentifyTarget.PlayerName, Canvas.ClipY - 256 * Scale);
	}
	return true;
}

//=====================================================================
// Deal with a localized message.

simulated function LocalizedMessage( class<LocalMessage> Message, optional int Switch, optional PlayerReplicationInfo RelatedPRI_1, optional PlayerReplicationInfo RelatedPRI_2, optional Object OptionalObject, optional String CriticalString )
{
	local int i;

	if ( ClassIsChildOf( Message, class'PickupMessagePlus' ) )
		PickupTime = Level.TimeSeconds;

	if ( !Message.Default.bIsSpecial )
	{
		if ( ClassIsChildOf(Message, class'SayMessagePlus') || 
						 ClassIsChildOf(Message, class'TeamSayMessagePlus') )
		{
			FaceTexture = RelatedPRI_1.TalkTexture;
			if ( FaceTexture != None )
				FaceTime = Level.TimeSeconds + 3;
		} 
		// Find an empty slot.
		for (i=0; i<4; i++)
		{
			if ( ShortMessageQueue[i].Message == None )
			{
				ShortMessageQueue[i].Message = Message;
				ShortMessageQueue[i].Switch = Switch;
				ShortMessageQueue[i].RelatedPRI = RelatedPRI_1;
				ShortMessageQueue[i].OptionalObject = OptionalObject;
				ShortMessageQueue[i].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
				if ( Message.Default.bComplexString )
					ShortMessageQueue[i].StringMessage = CriticalString;
				else
					ShortMessageQueue[i].StringMessage = Message.Static.GetString(Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject);
				return;
			}

		}
		// No empty slots.  Force a message out.
		for (i=0; i<3; i++)
			CopyMessage(ShortMessageQueue[i], ShortMessageQueue[i+1]);

		ShortMessageQueue[3].Message = Message;
		ShortMessageQueue[3].Switch = Switch;
		ShortMessageQueue[3].RelatedPRI = RelatedPRI_1;
		ShortMessageQueue[3].OptionalObject = OptionalObject;
		ShortMessageQueue[3].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
		if ( Message.Default.bComplexString )
			ShortMessageQueue[3].StringMessage = CriticalString;
		else
			ShortMessageQueue[3].StringMessage = Message.Static.GetString(Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject);
		return;
	} 
	else 
	{
		if ( CriticalString == "" )
			CriticalString = Message.Static.GetString(Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject);
		if ( Message.Default.bIsUnique )
		{
			for (i=0; i<10; i++)
			{
				if (LocalMessages[i].Message != None)
				{
					if ((LocalMessages[i].Message == Message) 
						|| (LocalMessages[i].Message.Static.GetOffset(LocalMessages[i].Switch, 24, 640) 
								== Message.Static.GetOffset(Switch, 24, 640)) ) 
					{
						LocalMessages[i].Message = Message;
						LocalMessages[i].Switch = Switch;
						LocalMessages[i].RelatedPRI = RelatedPRI_1;
						LocalMessages[i].OptionalObject = OptionalObject;
						LocalMessages[i].LifeTime = Message.Default.Lifetime;
						LocalMessages[i].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
						LocalMessages[i].StringMessage = CriticalString;
						LocalMessages[i].DrawColor = Message.Static.GetColor(Switch, RelatedPRI_1, RelatedPRI_2);				
						LocalMessages[i].XL = 0;
						return;
					}
				}
			}
		}
		for (i=0; i<10; i++)
		{
			if (LocalMessages[i].Message == None)
			{
				LocalMessages[i].Message = Message;
				LocalMessages[i].Switch = Switch;
				LocalMessages[i].RelatedPRI = RelatedPRI_1;
				LocalMessages[i].OptionalObject = OptionalObject;
				LocalMessages[i].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
				LocalMessages[i].StringMessage = CriticalString;
				LocalMessages[i].DrawColor = Message.Static.GetColor(Switch, RelatedPRI_1, RelatedPRI_2);				
				LocalMessages[i].LifeTime = Message.Default.Lifetime;
				LocalMessages[i].XL = 0;
				return;
			}
		}

		// No empty slots.  Force a message out.
		for (i=0; i<9; i++)
			CopyMessage(LocalMessages[i],LocalMessages[i+1]);

		LocalMessages[9].Message = Message;
		LocalMessages[9].Switch = Switch;
		LocalMessages[9].RelatedPRI = RelatedPRI_1;
		LocalMessages[9].OptionalObject = OptionalObject;
		LocalMessages[9].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
		LocalMessages[9].StringMessage = CriticalString;
		LocalMessages[9].DrawColor = Message.Static.GetColor(Switch, RelatedPRI_1, RelatedPRI_2);				
		LocalMessages[9].LifeTime = Message.Default.Lifetime;
		LocalMessages[9].XL = 0;
		return;
	}
}

defaultproperties
{
     VersionMessage="Version"
     PlayerCountString="Ideal Player Load:"
     MapTitleString="in"
     AuthorString="by"
     MapTitleString2="Map:"
     AuthorString2="Author:"
     RankString="Rank:"
     SpreadString="Spread:"
     CrosshairCount=9
     CrossHairs(0)="Botpack.CHair1"
     CrossHairs(1)="Botpack.CHair2"
     CrossHairs(2)="Botpack.CHair3"
     CrossHairs(3)="Botpack.CHair4"
     CrossHairs(4)="Botpack.CHair5"
     CrossHairs(5)="Botpack.CHair6"
     CrossHairs(6)="Botpack.CHair7"
     CrossHairs(7)="Botpack.CHair8"
     CrossHairs(8)="Botpack.CHair9"
     FP1(0)=Texture'Botpack.FacePanel.FacePanel1'
     FP1(1)=Texture'Botpack.FacePanel.FacePanel1b'
     FP1(2)=Texture'Botpack.FacePanel.FacePanel1a'
     FP2(0)=Texture'Botpack.FacePanel.FacePanel2'
     FP2(1)=Texture'Botpack.FacePanel.FacePanel2b'
     FP2(2)=Texture'Botpack.FacePanel.FacePanel2a'
     FP3(0)=Texture'Botpack.FacePanel.FacePanel3'
     FP3(1)=Texture'Botpack.FacePanel.FacePanel3b'
     FP3(2)=Texture'Botpack.FacePanel.FacePanel3a'
     bStartUpMessage=True
     bUseTeamColor=True
     Opacity=15
     HUDScale=1.000000
     StatusScale=1.000000
     WeaponScale=0.800000
     FavoriteHUDColor=(B=16)
     CrosshairColor=(G=16)
     Style=3
     WhiteColor=(R=255,G=255,B=255)
     RedColor=(R=255)
     GreenColor=(G=255)
     CyanColor=(G=255,B=255)
     UnitColor=(R=1,G=1,B=1)
     BlueColor=(B=255)
     GoldColor=(R=255,G=255)
     PurpleColor=(R=255,B=255)
     TurqColor=(G=128,B=255)
     GrayColor=(R=100,G=100,B=100)
     FaceColor=(R=50,G=50,B=50)
     IdentifyName="Name:"
     IdentifyHealth="Health:"
     IdentifyCallsign="Callsign:"
     LiveFeed="Live Feed from "
     ScoreTime=-10000000.000000
     ServerInfoClass=Class'Botpack.ServerInfo'
     FontInfoClass="Botpack.FontInfo"
     HUDConfigWindowType="UTMenu.UTChallengeHUDConfig"
     bSetStart=False
     WarningColor=(R=255,G=255,B=255)
     WarningCountDown=500
     MapsCountDown=500
     bRenderMaps=True
}
